using System.Data.SqlClient;
using System.Transactions;
using NUnit.Framework;

namespace TransactionScopeNUnitTest
{
    [TestFixture]
    public class TestClass
    {
        private const string connString = @"Server=.\sql2005;database=test;uid=<myUID>;pwd=<myPassword>";

        private TransactionScope scope;

        [TestFixtureSetUp]
        public void Setup()
        {
            scope = new TransactionScope(TransactionScopeOption.RequiresNew);
        }

        [TestFixtureTearDown]
        public void TearDown()
        {
            if (scope != null)
            {
                scope.Dispose();
            }
        }

        [Test]
        public void Delete()
        {
            // test runner could run the tests in any order
            // so we insert the a known entry first
            Insert();
            
            using (SqlConnection conn = new SqlConnection(connString))
            {
                using (SqlCommand cmd = new SqlCommand(
                    "DELETE FROM Table1 WHERE Col1 = 1"))
                {
                    cmd.Connection = conn;
                    conn.Open();
                    cmd.ExecuteNonQuery();
                    Verify();
                }
            }
        }

        [Test]
        public void Insert()
        {
            using (SqlConnection conn = new SqlConnection(connString))
            {
                using (SqlCommand cmd = new SqlCommand(
                    "INSERT INTO Table1 (Col1, Col2) VALUES (2, '2')"))
                {
                    cmd.Connection = conn;
                    conn.Open();
                    int retval = cmd.ExecuteNonQuery();
                    Assert.Greater(retval, 0);
                }
            }
        }

        [Test]
        public void Verify()
        {
            using (SqlConnection conn = new SqlConnection(connString))
            {
                using (SqlCommand cmd = new SqlCommand(
                    "SELECT * FROM Table1 WHERE Col1 = 2"))
                {
                    cmd.Connection = conn;
                    conn.Open();
                    SqlDataReader rdr = cmd.ExecuteReader();
                    Assert.IsTrue(rdr.HasRows, "Inserted Row Not Found");
                }
            }
        }
    }
}