using System;
using System.Data.SqlClient;
using System.Transactions;
using System.Threading;

class Demo
{
    static string connectionString;

    static void Main(string[] argv)
    {
        // ** Change connection strings accordingly

        Console.WriteLine("TransactioScope - BASIC");
        Console.WriteLine("============================");
        connectionString = @"server=.\sql2005;database=testDB;integrated security=SSPI";
        TransactionScopeTest();

        Console.WriteLine();
        Console.WriteLine("TransactioScope - IMPLICIT UNBIND");
        Console.WriteLine("============================");
        connectionString = @"server=.\sql2005;database=testDB;integrated security=SSPI;transaction binding=implicit Unbind;";
        TransactionScopeTest();

        Console.WriteLine();
        Console.WriteLine("TransactioScope - EXPLICIT UNBIND");
        Console.WriteLine("============================");
        connectionString = @"server=.\sql2005;database=testDB;integrated security=SSPI;transaction binding=explicit Unbind;";
        TransactionScopeTest();

        Console.ReadKey();
    }

    private static void TransactionScopeTest()
    { 
        try
        {
            ReCreateTable();
            Console.WriteLine("Table recreated");

            try
            {
                using (TransactionScope tx = new TransactionScope(TransactionScopeOption.RequiresNew, TimeSpan.FromSeconds(2)))
                {
                    Console.WriteLine("Transaction started lasting 2 seconds");
                    using (SqlConnection con = new SqlConnection(connectionString)) // connection string is set in main method (see examples)
                    {
                        con.Open();
                        Console.WriteLine("Server is {0}", con.ServerVersion);
                        Console.WriteLine("Clr is {0}", Environment.Version);

                        for (int i = 0; i < 5; i++)
                        {
                            using (SqlCommand cmd = con.CreateCommand())
                            {
                                cmd.CommandText = "insert into TXTEST values ( " + i + " )";
                                cmd.ExecuteNonQuery();
                                Console.WriteLine("Row inserted");
                            }

                            Thread.Sleep(TimeSpan.FromSeconds(1));
                        }

                        Console.WriteLine("Committing... now we get the timeout (sort of)");

                        tx.Complete();
                    }
                }
            }

            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }

            Console.WriteLine("Table contains {0} rows!!!", CountTable());
            DropTable();
        }

        catch (Exception e)
        {
            Console.WriteLine("Unexpected error:");
            Console.WriteLine(e.ToString());
        }
    }

    static void ReCreateTable()
    {
        try
        {
            DropTable();
        }

        catch (Exception) { }

        using (SqlConnection con = new SqlConnection(connectionString)) // connection string is set in main method (see examples)
        {
            con.Open();
            using (SqlCommand cmd = new SqlCommand("create table TXTEST ( F1 int )", con))
                cmd.ExecuteNonQuery();
        }
    }

    static int CountTable()
    {
        using (SqlConnection con = new SqlConnection(connectionString)) // connection string is set in main method (see examples)
        {
            con.Open();
            using (SqlCommand cmd = new SqlCommand("select count(*) from TXTEST", con))
                return (int)cmd.ExecuteScalar();
        }
    }

    static void DropTable()
    {
        using (SqlConnection con = new SqlConnection(connectionString)) // connection string is set in main method (see examples)
        {
            con.Open();
            using (SqlCommand cmd = new SqlCommand("drop table TXTEST", con))
                cmd.ExecuteNonQuery();
        }
    }
}