using System;
using System.Data.SqlClient;
using System.Transactions;
using System.Threading;

class CommittableTransactionDemo
{
    static string connectionString;

    //static void Main(string[] argv)
    //{
    //    // ** Change connection strings accordingly

    //    Console.WriteLine();
    //    Console.WriteLine("Committable TX - BASIC");
    //    Console.WriteLine("============================");
    //    connectionString = @"server=.\sql2005;database=testDB;integrated security=SSPI";
    //    CommittableTransactionTest();

    //    Console.WriteLine();
    //    Console.WriteLine("Committable TX - IMPLICIT UNBIND");
    //    Console.WriteLine("============================");
    //    connectionString = @"server=.\sql2005;database=testDB;integrated security=SSPI;transaction binding=implicit Unbind;";
    //    CommittableTransactionTest();

    //    Console.WriteLine();
    //    Console.WriteLine("Committable TX - EXPLICIT UNBIND");
    //    Console.WriteLine("============================");
    //    connectionString = @"server=.\sql2005;database=testDB;integrated security=SSPI;transaction binding=explicit Unbind;";
    //    CommittableTransactionTest();

    //    Console.ReadKey();
    //}

    private static void CommittableTransactionTest()
    {
        try
        {
            ReCreateTable();
            Console.WriteLine("Table recreated");

            try
            {
                using (CommittableTransaction tx = new CommittableTransaction(TimeSpan.FromSeconds(2)))
                {
                    Console.WriteLine("Transaction started lasting 2 seconds");
                    using (SqlConnection con = new SqlConnection(connectionString))
                    {
                        con.Open();
                        Console.WriteLine("Server is {0}", con.ServerVersion);
                        Console.WriteLine("Clr is {0}", Environment.Version);

                        con.EnlistTransaction(tx);

                        for (int i = 0; i < 5; i++)
                        {
                            using (SqlCommand cmd = con.CreateCommand())
                            {
                                cmd.CommandText = "insert into TXTEST values ( " + i + " )";
                                cmd.ExecuteNonQuery();
                                Console.WriteLine("Row inserted");
                            }

                            Thread.Sleep(TimeSpan.FromSeconds(1));
                        }

                        Console.WriteLine("Committing... now we get the timeout (sort of)");

                        tx.Commit();
                    }
                }
            }

            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }

            Console.WriteLine("Table contains {0} rows!!!", CountTable());
            DropTable();
        }

        catch (Exception e)
        {
            Console.WriteLine("Unexpected error:");
            Console.WriteLine(e.ToString());
        }
    }

    static void ReCreateTable()
    {
        try
        {
            DropTable();
        }

        catch (Exception) { }

        using (SqlConnection con = new SqlConnection(connectionString))
        {
            con.Open();
            using (SqlCommand cmd = new SqlCommand("create table TXTEST ( F1 int )", con))
                cmd.ExecuteNonQuery();
        }
    }

    static int CountTable()
    {
        using (SqlConnection con = new SqlConnection(connectionString))
        {
            con.Open();
            using (SqlCommand cmd = new SqlCommand("select count(*) from TXTEST", con))
                return (int)cmd.ExecuteScalar();
        }
    }

    static void DropTable()
    {
        using (SqlConnection con = new SqlConnection(connectionString))
        {
            con.Open();
            using (SqlCommand cmd = new SqlCommand("drop table TXTEST", con))
                cmd.ExecuteNonQuery();
        }
    }
}