using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using Infragistics.WebUI.UltraWebGrid;

public partial class MultiSelectWebCombo : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
    }

    protected string WebCombo1ClientID
    {
        get { return WebCombo1.ClientID; }
    }

    protected string WebCombo1InfraID
    {
        get
        {
            // infragistics replaces "_" in client id with "x"
            return WebCombo1ClientID.Replace("_", "x");
        }
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        // issue: firefox doesn't persist checkbox selections by the user
        // work-around was to save the selected channel IDs in the client side
        // via form submit
        // if using masterpages they can either be set using a button onclick event or 
        // some other approach for as long as SetValues() javascript function is called before
        // coming back to the server

        string hdValueValue = hdValue.Value;
        string[] selectedValues =
            hdValueValue.Split(
                new char[] { '|' },
                StringSplitOptions.RemoveEmptyEntries);

        List<string> valueList = new List<string>(selectedValues);

        // retain selection (again values will be lost with postback/callback in firefox)
        // code to determine browser might not be the best way to do it but works for me
        bool persistSelection = this.Page.Request.Browser.IsBrowser("mozillaFirefox");
        if (persistSelection)
        {
            foreach (UltraGridRow row in WebCombo1.Rows)
            {
                UltraGridCell idCell = row.Cells.FromKey("ID");
                UltraGridCell selectCell = row.Cells.FromKey("Select");
                selectCell.Value =
                    valueList.Contains(
                        idCell.Value.ToString());
            }
        }
    }
}
