<%@ Page AutoEventWireup="true" CodeFile="MultiSelectWebCombo.aspx.cs" Inherits="MultiSelectWebCombo"
    Language="C#" %>

<%@ Register Assembly="Infragistics2.WebUI.WebCombo.v7.3, Version=7.3.20073.38, Culture=neutral, PublicKeyToken=7dd5c3163f2cd0cb"
    Namespace="Infragistics.WebUI.WebCombo" TagPrefix="igcmbo" %>
<%@ Register Assembly="Infragistics2.WebUI.UltraWebGrid.v7.3, Version=7.3.20073.38, Culture=neutral, PublicKeyToken=7dd5c3163f2cd0cb"
    Namespace="Infragistics.WebUI.UltraWebGrid" TagPrefix="igtbl" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>Multiselect Webcombo</title>
</head>
<body>
    <form id="form1" runat="server" onsubmit="SetValues()">
        <div>
            <igcmbo:WebCombo ID="WebCombo1" runat="server" BackColor="White" BorderColor="Silver"
                BorderStyle="Solid" BorderWidth="1px" ComboTypeAhead="None" DataSourceID="ObjectDataSource1"
                ForeColor="Black" SelBackColor="DarkBlue" SelForeColor="White" Version="4.00">
                <Columns>
                    <igtbl:TemplatedColumn Hidden="True">
                    </igtbl:TemplatedColumn>
                    <igtbl:UltraGridColumn AllowUpdate="Yes" CellButtonDisplay="Always" Key="Select"
                        Type="CheckBox">
                    </igtbl:UltraGridColumn>
                    <igtbl:UltraGridColumn BaseColumnName="ID" Hidden="True" IsBound="True" Key="ID">
                        <header caption="ID">
                        </header>
                    </igtbl:UltraGridColumn>
                    <igtbl:UltraGridColumn BaseColumnName="Name" IsBound="True" Key="Name">
                        <header caption="Name">
                        </header>
                    </igtbl:UltraGridColumn>
                </Columns>
                <ExpandEffects ShadowColor="LightGray" />
                <DropDownLayout AutoGenerateColumns="False" BaseTableName="TestTable" BorderCollapse="Separate"
                    GridLines="Horizontal" RowHeightDefault="20px" RowSelectors="No" Version="4.00"
                    XmlLoadOnDemandType="Synchronous">
                    <FrameStyle BackColor="Silver" BorderStyle="Ridge" BorderWidth="2px" Cursor="Default"
                        Font-Names="Verdana" Font-Size="10pt" Height="130px" Width="325px">
                    </FrameStyle>
                    <HeaderStyle BackColor="LightGray" BorderStyle="Solid">
                        <BorderDetails ColorLeft="White" ColorTop="White" WidthLeft="1px" WidthTop="1px" />
                    </HeaderStyle>
                    <RowStyle BackColor="White" BorderColor="Gray" BorderStyle="Solid" BorderWidth="1px">
                        <BorderDetails WidthLeft="0px" WidthTop="0px" />
                    </RowStyle>
                    <SelectedRowStyle BackColor="DarkBlue" ForeColor="White" />
                </DropDownLayout>
                <ClientSideEvents AfterCloseUp="WebCombo1_AfterCloseUp" AfterDropDown="WebCombo1_AfterDropDown" />
            </igcmbo:WebCombo>
            <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" SelectMethod="SelectAll"
                TypeName="TestClass"></asp:ObjectDataSource>
            <asp:Button ID="Button1" runat="server" OnClick="Button1_Click" Text="Button" /></div>
        <asp:HiddenField ID="hdValue" runat="server" />

        <script type="text/javascript">
                var fromCloseUp = false;
                var firstDrop = false;
                var show = false;
                function WebCombo1_AfterCloseUp(webComboId)
                {
                    if(show)
                    {
                        fromCloseUp = true;
                        var oCombo=igcmbo_getComboById(webComboId);
                        oCombo.setDropDown(true);
                    }
                }
                
                function WebCombo1_AfterDropDown(webComboId)
                {
                    show = true;
                    if(fromCloseUp)
                        fromCloseUp = false;
                    
                    else
                        firstDrop = true;
                }

                document.onclick = function(evt) {
                    var oCombo=igcmbo_getComboById('<%= WebCombo1InfraID %>'); 
                    var div = oCombo.getGrid().getDivElement();  
                    if(clickedOutsideElement(evt, div.id))
                    {
                        if(firstDrop)
                            firstDrop = false;
                        
                        else
                        {
                            show = false;
                            oCombo.setDropDown(false);
                        }
                    }
                }
                
                function clickedOutsideElement(evt, elemId) {
                    var theElem = getEventTarget(evt);
                    while(theElem != null) {
                        if(theElem.id == elemId)
                        return false;

                        theElem = theElem.offsetParent;
                    }

                    return true;
                }

                function getEventTarget(evt) {
                    if (!evt && window.event) {
                        evt = window.event;
                    }
                    
                    var targ = (evt.target) ? evt.target : evt.srcElement;
                    if(targ != null) {
                        if(targ.nodeType == 3)
                        targ = targ.parentNode;
                    }

                    return targ;
                }  
                
                function SetValues()
                {
                    var hdValue = document.getElementById('<%= hdValue.ClientID %>');
                    var csv = '';
                    var oCombo=igcmbo_getComboById('<%= WebCombo1ClientID %>');   
                    var oGrid = oCombo.getGrid();
                    var rowCount = oGrid.Rows.length;
                    var selectCell;
                    var keyCell;
                    for (var a = 0; a < rowCount; a++)
                    {
                        var row = oGrid.Rows.getRow(a);
                        selectCell = row.getCellFromKey('Select');
                        keyCell = row.getCellFromKey('ID');
                        if(selectCell.getValue() == 'true')
                        {
                            csv += keyCell.getValue();
                            csv += '|';
                        }
                    }
                    
                    hdValue.value = csv;
                }
        </script>

    </form>
</body>
</html>
