using System;
using System.Data.SqlClient;

namespace Console2
{
    internal class Program
    {
        private static void Main(string[] args)
        {
            string connectionString =
                @"Data Source=.\sql2005;Initial Catalog=AdventureWorks;Integrated Security=SSPI;";

            using (SqlConnection conn = new SqlConnection(connectionString))
            {
                conn.Open();

                // our command text containing two select queries
                string commandText =
                    "SELECT ProductCategoryID, Name FROM [Production].[ProductCategory]; " +
                    "SELECT ProductSubcategoryID, Name FROM [Production].[ProductSubcategory]";

                SqlCommand cmd = new SqlCommand(commandText, conn);
                using (SqlDataReader rdr = cmd.ExecuteReader())
                {
                    // look into categories result set
                    Console.WriteLine("Categories");
                    while (rdr.Read())
                    {
                        int categoryID = rdr.GetInt32(0); 
                        string categoryName = rdr.GetString(1);
                        // NOTE: be careful when using indexes (as in above)
                        // make sure they match the order of columns in your select query

                        Console.WriteLine(categoryID + "\t" + categoryName);
                    }

                    // look into categories result set
                    rdr.NextResult();

                    // for separation in display only
                    Console.WriteLine(String.Empty.PadLeft(20, '-'));
                    
                    Console.WriteLine("SubCategories");
                    while (rdr.Read())
                    {
                        int subCategoryID = rdr.GetInt32(0);
                        string subCategoryName = rdr.GetString(1);
                        Console.WriteLine(subCategoryID + "\t" + subCategoryName);
                    }
                }
            }

            Console.ReadKey();
        }
    }
}